/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.xml.DomUtils;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XMLProcessor;
import org.wamblee.xml.XMLSchema;
import org.wamblee.xml.XMLTextProcessor;
import org.wamblee.xml.XSLTransformation;

public class XMLDocument {
    private static final Logger LOG = Logger.getLogger(XMLDocument.class.getName());
    private DOMSource doc;

    public XMLDocument(DOMSource aDoc) {
        this.doc = aDoc;
    }

    public XMLDocument(URI aUri) throws IOException, XMLException {
        this(aUri.toString(), aUri.toURL().openStream());
    }

    public XMLDocument(String aSystemId, String aContents) throws XMLException {
        this(aSystemId, new ByteArrayInputStream(aContents.getBytes()));
    }

    public XMLDocument(String aSystemId, InputStream aStream) throws XMLException {
        LSInput input = DomUtils.getDomImplementationLS().createLSInput();
        input.setByteStream(aStream);
        input.setSystemId(aSystemId);
        this.doc = XMLDocument.read(input, null);
    }

    public XMLDocument(String aSystemId, LSResourceResolver aResolver) throws XMLException {
        LSInput input = aResolver.resolveResource(null, null, null, aSystemId, null);
        this.doc = XMLDocument.read(input, aResolver);
    }

    public static XMLDocument xmldocument(URI aUri) throws IOException, XMLException {
        return new XMLDocument(aUri);
    }

    public static XMLDocument xmldocument(String aSystemId, String aContents) throws XMLException {
        return new XMLDocument(aSystemId, aContents);
    }

    public static XMLDocument xmldocument(String aSystemId, InputStream aStream) throws XMLException {
        return new XMLDocument(aSystemId, aStream);
    }

    public static XMLDocument xmldocument(String aSystemId, LSResourceResolver aResolver) throws XMLException {
        return new XMLDocument(aSystemId, aResolver);
    }

    public DOMSource getDOMSource() {
        return this.doc;
    }

    public Document getDocument() {
        return (Document)this.doc.getNode();
    }

    public XMLDocument process(XMLProcessor aProcessor) throws XMLException {
        return new XMLDocument(aProcessor.process(this.doc));
    }

    public void write(XMLTextProcessor aProcessor, OutputStream aOs) throws XMLException {
        aProcessor.write(this.doc, aOs);
    }

    public String write(XMLTextProcessor aProcessor) throws XMLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(aProcessor, bos);
        return bos.toString();
    }

    public XMLDocument transform(URI aUri) throws XMLException {
        return this.process(new XSLTransformation(aUri));
    }

    public XMLDocument transform(String aSystemId, URIResolver aResolver) throws XMLException {
        return this.process(new XSLTransformation(aSystemId, aResolver));
    }

    public XMLDocument validate(URI aUri) throws XMLException {
        return this.process(new XMLSchema(aUri));
    }

    public XMLDocument validate(String aSystemId, LSResourceResolver aResolver) throws XMLException {
        return this.process(new XMLSchema(aSystemId, aResolver));
    }

    public void print(OutputStream aOs, boolean aPrettyPrint) {
        try {
            this.write(new XSLTransformation().setPrettyPrint(aPrettyPrint), aOs);
        }
        catch (XMLException e) {
            throw new RuntimeException("Programming error, cannot print a DOM tree?: " + this.doc.getSystemId(), e);
        }
    }

    public String print(boolean aPrettyPrint) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.print(bos, aPrettyPrint);
        return bos.toString();
    }

    private static DOMSource read(LSInput aInput, LSResourceResolver aResolver) throws XMLException {
        try {
            DOMImplementationLS impl = DomUtils.getDomImplementationLS();
            LSParser builder = impl.createLSParser((short)1, null);
            if (aResolver != null) {
                builder.getDomConfig().setParameter("resource-resolver", aResolver);
            }
            Document docraw = builder.parse(aInput);
            DOMSource result = new DOMSource(docraw);
            result.setSystemId(aInput.getSystemId());
            return result;
        }
        catch (LSException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }
}

