/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence.hibernate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.wamblee.persistence.Persistent;

public class HibernateSupport
extends HibernateDaoSupport {
    private static final Log LOG = LogFactory.getLog(HibernateSupport.class);

    public void merge(Persistent aPersistent) {
        HibernateSupport.merge(this.getHibernateTemplate(), aPersistent);
    }

    public static void merge(HibernateTemplate aTemplate, Persistent aPersistent) {
        Persistent merged = (Persistent)aTemplate.merge((Object)aPersistent);
        HibernateSupport.processPersistent(aPersistent, merged, new ArrayList<ObjectElem>());
    }

    public static void processPersistent(Persistent aPersistent, Persistent aMerged, List<ObjectElem> aProcessed) {
        Method[] methods;
        if (aPersistent == null && aMerged == null) {
            return;
        }
        if (aPersistent == null || aMerged == null) {
            throw new RuntimeException("persistent or merged object is null '" + aPersistent + "'" + "  '" + aMerged + "'");
        }
        ObjectElem elem = new ObjectElem(aPersistent);
        if (aProcessed.contains(elem)) {
            return;
        }
        aProcessed.add(elem);
        LOG.debug((Object)("Setting pk/version on " + aPersistent + " from " + aMerged));
        if (aPersistent.getPrimaryKey() != null && !aMerged.getPrimaryKey().equals(aPersistent.getPrimaryKey())) {
            LOG.error((Object)("Mismatch between primary key values: " + aPersistent + " " + aMerged));
        } else {
            aPersistent.setPersistedVersion(aMerged.getPersistedVersion());
            aPersistent.setPrimaryKey(aMerged.getPrimaryKey());
        }
        for (Method getter : methods = aPersistent.getClass().getMethods()) {
            if (!getter.getName().startsWith("get")) continue;
            Class<?> returnType = getter.getReturnType();
            try {
                Persistent[] persistent;
                Persistent[] merged;
                if (Set.class.isAssignableFrom(returnType)) {
                    merged = (Set)getter.invoke((Object)aMerged, new Object[0]);
                    persistent = (Set)getter.invoke((Object)aPersistent, new Object[0]);
                    HibernateSupport.processSet((Set)persistent, (Set)merged, aProcessed);
                    continue;
                }
                if (List.class.isAssignableFrom(returnType)) {
                    merged = (List)getter.invoke((Object)aMerged, new Object[0]);
                    persistent = (List)getter.invoke((Object)aPersistent, new Object[0]);
                    HibernateSupport.processList((List)persistent, (List)merged, aProcessed);
                    continue;
                }
                if (Map.class.isAssignableFrom(returnType)) {
                    merged = (Map)getter.invoke((Object)aMerged, new Object[0]);
                    persistent = (Map)getter.invoke((Object)aPersistent, new Object[0]);
                    HibernateSupport.processMap(persistent, merged, aProcessed);
                    continue;
                }
                if (Persistent.class.isAssignableFrom(returnType)) {
                    merged = (Persistent)getter.invoke((Object)aMerged, new Object[0]);
                    persistent = (Persistent)getter.invoke((Object)aPersistent, new Object[0]);
                    HibernateSupport.processPersistent((Persistent)persistent, (Persistent)merged, aProcessed);
                    continue;
                }
                if (!returnType.isArray() || !Persistent.class.isAssignableFrom(returnType.getComponentType())) continue;
                merged = (Persistent[])getter.invoke((Object)aMerged, new Object[0]);
                persistent = (Persistent[])getter.invoke((Object)aPersistent, new Object[0]);
                for (int i = 0; i < persistent.length; ++i) {
                    HibernateSupport.processPersistent(persistent[i], merged[i], aProcessed);
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static void processList(List aPersistent, List aMerged, List<ObjectElem> aProcessed) {
        Object[] persistent;
        Object[] merged = aMerged.toArray();
        if (merged.length != (persistent = aPersistent.toArray()).length) {
            throw new RuntimeException("Array sizes differ " + merged.length + " " + persistent.length);
        }
        for (int i = 0; i < merged.length; ++i) {
            assert (merged[i].equals(persistent[i]));
            if (!(merged[i] instanceof Persistent)) continue;
            HibernateSupport.processPersistent((Persistent)persistent[i], (Persistent)merged[i], aProcessed);
        }
    }

    public static void processSet(Set aPersistent, Set aMerged, List<ObjectElem> aProcessed) {
        if (aMerged.size() != aPersistent.size()) {
            throw new RuntimeException("Array sizes differ " + aMerged.size() + " " + aPersistent.size());
        }
        block0: for (Object merged : aMerged) {
            for (Object persistent : aPersistent) {
                if (!persistent.equals(merged)) continue;
                HibernateSupport.processPersistent((Persistent)persistent, (Persistent)merged, aProcessed);
                continue block0;
            }
        }
    }

    public static <Key, Value> void processMap(Map<Key, Value> aPersistent, Map<Key, Value> aMerged, List<ObjectElem> aProcessed) {
        if (aMerged.size() != aPersistent.size()) {
            throw new RuntimeException("Sizes differ " + aMerged.size() + " " + aPersistent.size());
        }
        Set<Map.Entry<Key, Value>> entries = aMerged.entrySet();
        for (Map.Entry<Key, Value> entry : entries) {
            Key key = entry.getKey();
            if (!aPersistent.containsKey(key)) {
                throw new RuntimeException("Key '" + key + "' not found");
            }
            Value mergedValue = entry.getValue();
            Value persistentValue = aPersistent.get(key);
            if (!(mergedValue instanceof Persistent)) continue;
            if (persistentValue instanceof Persistent) {
                HibernateSupport.processPersistent((Persistent)persistentValue, (Persistent)mergedValue, aProcessed);
                continue;
            }
            throw new RuntimeException("Value in original object is null, whereas merged object contains a value");
        }
    }

    private static final class ObjectElem {
        private Object object;

        public ObjectElem(Object aObject) {
            this.object = aObject;
        }

        public boolean equals(Object aObj) {
            if (aObj == null) {
                return false;
            }
            if (!(aObj instanceof ObjectElem)) {
                return false;
            }
            return ((ObjectElem)aObj).object == this.object;
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

