/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general.spring;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.wamblee.general.BeanFactory;
import org.wamblee.general.BeanFactoryException;

public class SpringBeanFactory
implements BeanFactory {
    private BeanFactoryReference factoryReference;

    public SpringBeanFactory(String aSelector, String aFactoryName) {
        try {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)aSelector);
            this.factoryReference = locator.useBeanFactory(aFactoryName);
        }
        catch (BeansException e) {
            throw new BeanFactoryException("Could not load bean factory: selector = '" + aSelector + "', factory = '" + aFactoryName + "'", (Throwable)e);
        }
    }

    public Object find(String aId) {
        return this.find(aId, Object.class);
    }

    public <T> T find(Class<T> aClass) {
        return this.find(aClass.getName(), aClass);
    }

    public <T> T find(String aId, Class<T> aClass) {
        try {
            Object obj = this.factoryReference.getFactory().getBean(aId, aClass);
            assert (obj != null);
            return aClass.cast(obj);
        }
        catch (BeansException e) {
            throw new BeanFactoryException(e.getMessage(), (Throwable)e);
        }
    }

    public org.springframework.beans.factory.BeanFactory getSpringBeanFactory() {
        return this.factoryReference.getFactory();
    }
}

