/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.persistence.hibernate;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Hibernate mapping files to use.
 * 
 * @author Erik Brakkee
 */
public class HibernateMappingFiles extends ArrayList<String> {
    /**
     * Constructs an empty list of hibernate mapping files.
     * 
     */
    public HibernateMappingFiles() {
        super();
    }

    /**
     * Constructs the list of Spring config files.
     * 
     * @param aFiles
     *            Files.
     */
    public HibernateMappingFiles(String[] aFiles) {
        super();
        addAll(Arrays.asList(aFiles));
    }
}
