/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency.spring;

import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.wamblee.concurrency.AbstractLockTestCase;
import org.wamblee.concurrency.JvmLock;
import org.wamblee.concurrency.Lock;
import org.wamblee.concurrency.spring.LockAdvice;
import org.wamblee.test.TimingUtils;

public class LockAdviceTest
extends AbstractLockTestCase {
    private Runnable target;

    protected void setUp() throws Exception {
        super.setUp();
        Runner runner = new Runner();
        LockAdvice advice = new LockAdvice((Lock)new JvmLock());
        ProxyFactoryBean support = new ProxyFactoryBean();
        support.setInterfaces(new Class[]{Runnable.class});
        support.setTarget((Object)runner);
        support.addAdvice((Advice)advice);
        this.target = (Runnable)support.getObject();
    }

    protected Thread runThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LockAdviceTest.this.getTracker().eventOccurred((Object)"started");
                    LockAdviceTest.this.target.run();
                    LockAdviceTest.this.getTracker().eventOccurred((Object)"released");
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        t.start();
        return t;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            LockAdviceTest.this.getTracker().eventOccurred((Object)"acquired");
            TimingUtils.sleep((int)1000);
        }
    }
}

