/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.spring;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.oro.io.AwkFilenameFilter;
import org.hibernate.cfg.Configuration;
import org.wamblee.io.ClassPathResource;

public final class HibernateUtils {
    private static final String DATABASE_PROPS = "test.database.properties";

    private HibernateUtils() {
    }

    public static Configuration getConfiguration(File aDir) throws IOException {
        File[] files;
        Configuration conf = new Configuration();
        for (File f : files = aDir.listFiles((FileFilter)new AwkFilenameFilter(".*\\.hbm\\.xml"))) {
            System.out.println("Mapping file: " + f);
            conf.addFile(f);
        }
        Map<String, String> dbProps = HibernateUtils.getHibernateProperties();
        for (Map.Entry<String, String> entry : dbProps.entrySet()) {
            System.out.println("Property: " + entry.getKey() + "=" + entry.getValue());
            conf.setProperty(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    private static Map<String, String> getHibernateProperties() throws IOException {
        System.out.println("Reading properties file: test.database.properties");
        ClassPathResource lPropFile = new ClassPathResource(DATABASE_PROPS);
        Properties props = new Properties();
        props.load(lPropFile.getInputStream());
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("hibernate.connection.driver_class", props.getProperty("database.driver"));
        result.put("hibernate.connection.url", props.getProperty("database.url"));
        result.put("hibernate.connection.username", props.getProperty("database.username"));
        result.put("hibernate.connection.password", props.getProperty("database.password"));
        return result;
    }
}

