/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general.spring;

import junit.framework.TestCase;
import org.wamblee.general.spring.SpringBeanFactory;
import org.wamblee.ioc.BeanFactoryException;

public class SpringBeanFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testExistingBeanRefContext() {
        SpringBeanFactory factory = new SpringBeanFactory("org/wamblee/general/beanRefContext.xml", "test");
        String value1 = (String)factory.find(String.class);
        SpringBeanFactoryTest.assertEquals((String)"hello", (String)value1);
        String value2 = (String)factory.find("java.lang.String");
        SpringBeanFactoryTest.assertEquals((String)"hello", (String)value2);
        String value3 = (String)factory.find("java.lang.String", String.class);
        SpringBeanFactoryTest.assertEquals((String)"hello", (String)value3);
        try {
            factory.find("unknown");
        }
        catch (BeanFactoryException e) {
            return;
        }
        SpringBeanFactoryTest.fail();
    }

    public void testUnknownBeanFactory() {
        try {
            new SpringBeanFactory("org/wamblee/general/beanRefContext.xml", "unknown");
        }
        catch (BeanFactoryException e) {
            return;
        }
        SpringBeanFactoryTest.fail();
    }
}

