/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.test.persistence.eclipselink;

import java.io.File;
import java.util.Map;

import org.dbunit.dataset.filter.ITableFilterSimple;
import org.wamblee.io.FileSystemUtils;
import org.wamblee.test.persistence.JpaCustomizer;
import org.wamblee.test.persistence.PersistenceUnitDescription;

/**
 * 
 * @author $author$
 * @version $Revision$
 */
public class EclipselinkJpaCustomizer implements JpaCustomizer {
    /**
     * Creates a new EclipselinkJpaCustomizer object.
     */
    public EclipselinkJpaCustomizer() {
        // Empty
    }

    @Override
    public void customize(PersistenceUnitDescription aPersistenceUnit,
        Map<String, String> aJpaProperties) {
  
        // DDL generation
        aJpaProperties.put("eclipselink.ddl-generation", "drop-and-create-tables");
        
        // DDL generation
        FileSystemUtils.createDir(new File("target/sql"));
        aJpaProperties.put("eclipselink.application-location", "target/sql");
        aJpaProperties.put("eclipselink.create-ddl-jdbc-file-name", "create-schema.sql");
        aJpaProperties.put("eclipselink.drop-ddl-jdbc-file-name", "drop-schema.sql");
        aJpaProperties.put("eclipselink.ddl-generation.output-mode", "both");
    }

    @Override
    public ITableFilterSimple getJpaTables() {
        return new EclipselinkTables();
    }
}
