/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;

import java.util.ArrayList;
import java.util.List;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.ITableFilterSimple;

public class CompositeJpaTables implements ITableFilterSimple {

    private List<ITableFilterSimple> tables;

    public CompositeJpaTables() {
        tables = new ArrayList<ITableFilterSimple>();
    }

    public void add(ITableFilterSimple aFilter) {
        tables.add(aFilter);
    }

    @Override
    public boolean accept(String aTableName) throws DataSetException {
        for (ITableFilterSimple filter : tables) {
            if (filter.accept(aTableName)) {
                return true;
            }
        }
        return false;
    }

}
