/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;

import javax.sql.DataSource;

/**
 * Represents a database.
 * 
 * @author Erik Brakkee
 */
public interface Database {

    /**
     * Starts a database. This call should not block and return as soon as the
     * database has been started.
     */
    DataSource start();
    
    /**
     * Gets the number of active connections from the pool. This is useful for 
     * determining resource leaks. 
     * @return Active connections. 
     */
    int getActiveConnections(); 

    /**
     * Gets the Jdbc Url to connect to this database.
     * 
     * @return Jdbc Url.
     */
    String getJdbcUrl();

    /**
     * Gets the external Jdbc URL to connect to this database from other JVMs.
     */
    String getExternalJdbcUrl();

    /**
     * Gets the username to connect to the database.
     * 
     * @return username.
     */
    String getUsername();

    /**
     * Gets the password to connect to the database.
     * 
     * @return password.
     */
    String getPassword();

    /**
     * Stops a database.
     */
    void stop();
}
