/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;

/**
 * Database provider. This database provider represents a particular type of
 * database such as its capabilities and the ability to create an instance
 * representing a running database.
 * 
 * Since the {@link DatabaseBuilder} uses a first match algorithm and the order
 * of databaseproviders is not guaranteed, it is recommended for each database
 * provider to also provide a unique capability that no other database has.
 */
public interface DatabaseProvider {

    /**
     * Capability that all databases that run inmemory have.
     */
    String CAPABILITY_IN_MEMORY = "INMEMORY";

    /**
     * Capability that all databases that are external have.
     */
    String CAPABILITY_EXTERNAL = "EXTERNAL";

    /**
     * Determines if the database has all capabilities that are requested.
     * 
     * @param aCapabilities
     *            Capabilities it must ahve
     * @return True if it has all capabilities.
     */
    boolean supportsCapabilities(String[] aCapabilities);

    /**
     * Gets the description for the database.
     * 
     * @return Description.
     */
    DatabaseDescription getDescription();

    /**
     * Creates a database instance that represents a running instance of that
     * database.
     * 
     * @return Database.
     */
    Database create();
}
