/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;

import java.util.Arrays;
import java.util.List;

/**
 * 
 * @author $author$
 * @version $Revision$
 */
public class DerbyDatabaseProvider extends AbstractDatabaseProvider {
    /**
     * Capabilities of this type of database.
     */
    public static final List<String> CAPABILIITIES = Arrays.asList(
        DatabaseProvider.CAPABILITY_IN_MEMORY, "DERBY");

    /**
     * Creates a new DerbyDatabaseProvider object.
     */
    public DerbyDatabaseProvider() {
        // Empty
    }

    public Database create() {
        return new DerbyDatabase();
    }

    public DatabaseDescription getDescription() {
        return new DatabaseDescription(CAPABILIITIES.toArray(new String[0]),
            "Derby", "In-memory, volatile, set breakpoint to debug");
    }

    @Override
    protected List<String> getCapabilities() {
        return CAPABILIITIES;
    }
}
