/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;


/**
 * Database that encapsulates connection to an external database. Database
 * connection details can be configured through system properties and
 * environment variables, see {@link #DB_URL_PROP}, {@link #DB_USER_PROP}, and
 * {@link #DB_PASSWORD_PROP|.
 * 
 * This class assumes modern database drivers that work together with
 * java.util.ServiceLoader so that explicitly doing a Class.forName() is not
 * necessary to load the database driver.
 */
public class ExternalDatabase extends AbstractDatabase {

    /**
     * System property/environment variable that defines the database URL.
     */
    public static final String DB_URL_PROP = "TEST_DB_URL";

    /**
     * System property/environment variable that defines the database user.
     */
    public static final String DB_USER_PROP = "TEST_DB_USER";

    /**
     * System property/environment variable that defines the database password.
     */
    public static final String DB_PASSWORD_PROP = "TEST_DB_PASSWORD";

    private String itsUrl;
    private String itsUser;
    private String itsPassword;

    public ExternalDatabase() {
        // Empty
    }

    public String getExternalJdbcUrl() {
        return itsUrl;
    }

    public String getJdbcUrl() {
        return itsUrl;
    }

    public String getPassword() {
        return itsPassword;
    }

    public String getUsername() {
        return itsUser;
    }

    public void doStart() {
        itsUrl = getProperty(DB_URL_PROP);
        itsUser = getProperty(DB_USER_PROP);
        itsPassword = getProperty(DB_PASSWORD_PROP);

        createDataSource();
    }

    public void doStop() {
        // Empty.
    }

}
