/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.support.persistence;

import java.util.Arrays;
import java.util.List;

public class ExternalDatabaseProvider extends AbstractDatabaseProvider {

    /**
     * Capabilities of this type of database.
     */
    public static final List<String> CAPABILIITIES = Arrays
        .asList(CAPABILITY_EXTERNAL);

    @Override
    protected List<String> getCapabilities() {
        return CAPABILIITIES;
    }

    public Database create() {
        return new ExternalDatabase();
    }

    public DatabaseDescription getDescription() {
        return new DatabaseDescription(
            CAPABILIITIES.toArray(new String[0]),
            "External Database",
            "Any database as described by the JDBC URL: requires system properties or environment variables: " +
                ExternalDatabase.DB_URL_PROP +
                ", " +
                ExternalDatabase.DB_USER_PROP +
                ", and " +
                ExternalDatabase.DB_PASSWORD_PROP);
    }

}
