/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.jndi;

import javax.naming.CompositeName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.wamblee.support.jndi.StubInitialContextFactory;

public class StubInitiaContextFactoryTest {
    private static final String JNDI_NAME = "a/b";

    @Before
    @After
    public void setUp() {
        StubInitialContextFactory.unregister();
    }

    @Test(expected=NamingException.class)
    public void testLookupNotRegistered() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.bind(JNDI_NAME, (Object)"hallo");
    }

    @Test
    public void testLookup() throws Exception {
        StubInitialContextFactory.register();
        InitialContext ctx = new InitialContext();
        ctx.bind(JNDI_NAME, (Object)"hallo");
        ctx = new InitialContext();
        Object obj = ctx.lookup(JNDI_NAME);
        Assert.assertEquals((Object)"hallo", (Object)obj);
    }

    @Test(expected=NameNotFoundException.class)
    public void testUnbind() throws Exception {
        this.testLookup();
        InitialContext ctx = new InitialContext();
        ctx.unbind(JNDI_NAME);
        ctx = new InitialContext();
        ctx.lookup(JNDI_NAME);
    }

    @Test(expected=NameNotFoundException.class)
    public void testLookupFails() throws Exception {
        StubInitialContextFactory.register();
        InitialContext ctx = new InitialContext();
        Object obj = ctx.lookup(JNDI_NAME);
    }

    @Test
    public void testLookupName() throws Exception {
        StubInitialContextFactory.register();
        InitialContext ctx = new InitialContext();
        ctx.bind(new CompositeName(JNDI_NAME), (Object)"hallo");
        ctx = new InitialContext();
        Object obj = ctx.lookup(new CompositeName(JNDI_NAME));
        Assert.assertEquals((Object)"hallo", (Object)obj);
    }

    @Test(expected=NameNotFoundException.class)
    public void testUnbindName() throws Exception {
        this.testLookup();
        InitialContext ctx = new InitialContext();
        ctx.unbind(new CompositeName(JNDI_NAME));
        ctx = new InitialContext();
        ctx.lookup(new CompositeName(JNDI_NAME));
    }

    @Test(expected=NameNotFoundException.class)
    public void testLookupFailsName() throws Exception {
        StubInitialContextFactory.register();
        InitialContext ctx = new InitialContext();
        Object obj = ctx.lookup(JNDI_NAME);
    }
}

