/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import javax.sql.DataSource;
import junit.framework.TestCase;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.wamblee.support.persistence.Database;
import org.wamblee.support.persistence.DatabaseBuilder;
import org.wamblee.support.persistence.DatabaseUtils;

public class DatabaseUtilsLeakTest {
    private Database db;
    private DatabaseUtils dbutils;

    @Before
    public void setUp() {
        this.db = DatabaseBuilder.getDatabase((String[])new String[0]);
        DataSource ds = this.db.start();
        this.dbutils = new DatabaseUtils(ds, new ITableFilterSimple(){

            public boolean accept(String aTableName) throws DataSetException {
                return false;
            }
        });
    }

    @After
    public void tearDown() {
        this.db.stop();
    }

    @Test
    public void testLeak() throws Exception {
        TestCase.assertEquals((int)0, (int)this.db.getActiveConnections());
        this.dbutils.dropTables();
        TestCase.assertEquals((int)0, (int)this.db.getActiveConnections());
    }
}

