/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import javax.persistence.EntityManager;
import junit.framework.Assert;
import org.dbunit.IDatabaseTester;
import org.dbunit.dataset.ITable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.wamblee.support.persistence.DatabaseUtils;
import org.wamblee.support.persistence.JpaBuilder;
import org.wamblee.support.persistence.JpaTester;
import org.wamblee.support.persistence.MyEntity;
import org.wamblee.support.persistence.MyPersistenceUnit;
import org.wamblee.support.persistence.PersistenceUnitDescription;

public class MyEntityExampleTestBase {
    private JpaTester jpaTester;
    private JpaBuilder builder;
    private IDatabaseTester dbtester;
    private DatabaseUtils dbutils;

    @Before
    public void setUp() throws Exception {
        this.jpaTester = new JpaTester((PersistenceUnitDescription)new MyPersistenceUnit());
        this.jpaTester.start();
        this.builder = this.jpaTester.getJpaBuilder();
        this.dbtester = this.jpaTester.getDbTester();
        this.dbutils = this.jpaTester.getDbUtils();
        this.dbutils.start();
    }

    @After
    public void tearDown() {
        this.dbutils.stop();
        this.jpaTester.stop();
    }

    @Test
    public void testEntityPersistence() throws Exception {
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                return null;
            }
        });
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        Assert.assertEquals((Object)"a", (Object)table.getValue(0, "SLEUTELTJE"));
        Assert.assertEquals((Object)"b", (Object)table.getValue(0, "VALUE"));
        Assert.assertEquals((int)1, (int)this.dbutils.getTableSize("XYZ_MYENTITY"));
    }
}

