/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ThreadSpecificProxyFactory<T> {
    private ThreadLocal<T> svc = new ThreadLocal();
    private Class clazz;

    public ThreadSpecificProxyFactory(Class<T> aClass) {
        if (!aClass.isInterface()) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not an interface");
        }
        this.clazz = aClass;
    }

    public void set(T aService) {
        this.svc.set(aService);
    }

    public T getProxy() {
        ThreadSpecificInvocationHandler handler = new ThreadSpecificInvocationHandler();
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }

    private class ThreadSpecificInvocationHandler
    implements InvocationHandler {
        private ThreadSpecificInvocationHandler() {
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            try {
                return aMethod.invoke(ThreadSpecificProxyFactory.this.svc.get(), aArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

