/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wamblee.support.persistence.Database;

public abstract class AbstractDatabase
implements Database {
    private static final String IGNORE_CONNECTION_LEAK_PROPERTY = "org.wamblee.database.ignoreconnectionleaks";
    private static final Logger LOGGER = Logger.getLogger(AbstractDatabase.class.getName());
    private static final int CONNECTION_POOL_SIZE = 16;
    private DataSource itsDataSource;
    private GenericObjectPool connectionPool;
    private boolean started = false;

    protected AbstractDatabase() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected final void createDataSource() {
        this.connectionPool = new GenericObjectPool(null);
        this.connectionPool.setMaxActive(16);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.getJdbcUrl(), this.getUsername(), this.getPassword());
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this.connectionPool, null, null, false, true);
        AbstractDatabase.ingoredVariable(poolableConnectionFactory);
        this.itsDataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
    }

    @Override
    public int getActiveConnections() {
        return this.connectionPool.getNumActive();
    }

    private static void ingoredVariable(PoolableConnectionFactory aFactory) {
    }

    @Override
    public final DataSource start() {
        if (this.started) {
            throw new RuntimeException("Database already started");
        }
        this.started = true;
        this.doStart();
        return this.getDatasource();
    }

    @Override
    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            if (this.connectionPool.getNumActive() > 0) {
                String msg = "JDBC connection pool still has " + this.connectionPool.getNumActive() + " active connection(s), this is a potential resource leak in the code\n";
                if (System.getProperty(IGNORE_CONNECTION_LEAK_PROPERTY) == null) {
                    Assert.fail((String)msg);
                }
            }
            this.connectionPool.close();
            this.connectionPool.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not close pool", e);
        }
        this.doStop();
    }

    private final DataSource getDatasource() {
        if (!this.started) {
            throw new RuntimeException("Database is not started!");
        }
        return this.itsDataSource;
    }

    protected String getProperty(String aName) {
        String value = System.getProperty(aName);
        if (value != null) {
            return value;
        }
        value = System.getenv(aName);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("This class expects the '" + aName + "' property to be set");
    }
}

