/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.util.List;
import java.util.Map;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.wamblee.support.persistence.CompositeJpaTables;
import org.wamblee.support.persistence.JpaCustomizer;
import org.wamblee.support.persistence.PersistenceUnitDescription;

public class CompositeJpaCustomizer
implements JpaCustomizer {
    private List<JpaCustomizer> customizers;
    private CompositeJpaTables tables;

    public CompositeJpaCustomizer(List<JpaCustomizer> aCustomizers) {
        this.customizers = aCustomizers;
        this.tables = new CompositeJpaTables();
        for (JpaCustomizer customizer : this.customizers) {
            this.tables.add(customizer.getJpaTables());
        }
    }

    @Override
    public void customize(PersistenceUnitDescription aPersistenceUnit, Map<String, String> aJpaProperties) {
        for (JpaCustomizer customizer : this.customizers) {
            customizer.customize(aPersistenceUnit, aJpaProperties);
        }
    }

    @Override
    public ITableFilterSimple getJpaTables() {
        return this.tables;
    }
}

