/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.wamblee.support.persistence.Database;
import org.wamblee.support.persistence.DatabaseDescription;
import org.wamblee.support.persistence.DatabaseProvider;

public class DatabaseBuilder {
    private static final Logger LOGGER = Logger.getLogger(DatabaseBuilder.class.getName());
    private static final String DB_CAPABILITIES_PROP = "TEST_DB_CAPABILITIES";
    private static ServiceLoader<DatabaseProvider> LOADER = ServiceLoader.load(DatabaseProvider.class);

    private DatabaseBuilder() {
    }

    private static String[] parseCapabilities(String aValue) {
        return aValue.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String ... aCapabilities) {
        if (aCapabilities.length == 0) {
            LOGGER.info("Examining database capabilities");
            LOGGER.info("  Checking system property TEST_DB_CAPABILITIES");
            String capabilities = System.getProperty(DB_CAPABILITIES_PROP);
            if (capabilities != null) {
                aCapabilities = DatabaseBuilder.parseCapabilities(capabilities);
            } else {
                LOGGER.info("  Checking environment variable TEST_DB_CAPABILITIES");
                capabilities = System.getenv(DB_CAPABILITIES_PROP);
                if (capabilities != null) {
                    aCapabilities = DatabaseBuilder.parseCapabilities(capabilities);
                } else {
                    LOGGER.info("  Using default capabilities");
                    aCapabilities = new String[]{"INMEMORY"};
                }
            }
            LOGGER.info("Using capabilities: " + Arrays.asList(aCapabilities));
        }
        Class<DatabaseBuilder> clazz = DatabaseBuilder.class;
        synchronized (DatabaseBuilder.class) {
            for (DatabaseProvider db : LOADER) {
                if (!db.supportsCapabilities(aCapabilities)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return db.create();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new RuntimeException("No database found that satisfies capabilities: " + Arrays.asList(aCapabilities));
        }
    }

    public static List<DatabaseDescription> getSupportedDatabases() {
        ArrayList<DatabaseDescription> descriptions = new ArrayList<DatabaseDescription>();
        for (DatabaseProvider db : LOADER) {
            descriptions.add(db.getDescription());
        }
        return descriptions;
    }
}

