/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.dbunit.DataSourceDatabaseTester;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.dbunit.operation.DatabaseOperation;

public class DatabaseUtils {
    private static final Logger LOG = Logger.getLogger(DatabaseUtils.class.getName());
    private static final String SCHEMA_PATTERN = "%";
    private DataSource dataSource;
    private ITableFilterSimple tables;
    private IDatabaseTester dbtester;
    private List<IDatabaseConnection> connections;

    public DatabaseUtils(DataSource aDataSource, ITableFilterSimple aTables) {
        this.dataSource = aDataSource;
        this.tables = aTables;
        this.dbtester = new DataSourceDatabaseTester(this.dataSource);
        this.connections = new ArrayList<IDatabaseConnection>();
    }

    public void start() {
    }

    public void stop() {
        for (IDatabaseConnection connection : this.connections) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Could not close connection", e);
            }
        }
        this.connections.clear();
    }

    public IDatabaseTester createDbTester() throws Exception {
        return this.createDbTester(this.getTableNames(this.tables));
    }

    public IDatabaseTester createDbTester(String[] aTables) throws Exception {
        IDatabaseConnection connection = this.dbtester.getConnection();
        this.connections.add(connection);
        this.dbtester.setDataSet(connection.createDataSet(aTables));
        return this.dbtester;
    }

    public void cleanDatabase() throws Exception {
        this.cleanDatabase(this.tables);
    }

    public void executeOnTables(ITableFilterSimple aTables, final TableSetOperation aOperation) throws Exception {
        final String[] tableNames = this.getTableNames(aTables);
        this.executeInTransaction(new JdbcUnitOfWork<Void>(){

            @Override
            public Void execute(Connection aConnection) throws Exception {
                for (int i = tableNames.length - 1; i >= 0; --i) {
                    aOperation.execute(tableNames[i]);
                }
                return null;
            }
        });
    }

    public void cleanDatabase(ITableFilterSimple aSelection) throws Exception {
        final String[] tableNames = this.getTableNames(aSelection);
        this.executeInTransaction(new JdbcUnitOfWork<Void>(){

            @Override
            public Void execute(Connection aConnection) throws Exception {
                DatabaseConnection connection = new DatabaseConnection(aConnection);
                DatabaseSequenceFilter filter = new DatabaseSequenceFilter((IDatabaseConnection)connection, tableNames);
                FilteredDataSet dataset = new FilteredDataSet((ITableFilter)filter, connection.createDataSet(tableNames));
                DatabaseOperation.DELETE_ALL.execute((IDatabaseConnection)connection, (IDataSet)dataset);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInTransaction(JdbcUnitOfWork<T> aCallback) throws Exception {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        try {
            T value = aCallback.execute(connection);
            connection.commit();
            T t = value;
            return t;
        }
        finally {
            connection.close();
        }
    }

    public String[] getTableNames() throws Exception {
        return this.getTableNames(this.tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableNames(ITableFilterSimple aSelection) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        LOG.fine("Getting database table names to clean (schema: '%'");
        Connection connection = this.dataSource.getConnection();
        try {
            ResultSet tableNames = connection.getMetaData().getTables(null, SCHEMA_PATTERN, SCHEMA_PATTERN, new String[]{"TABLE"});
            while (tableNames.next()) {
                String table = tableNames.getString("TABLE_NAME");
                if (!aSelection.accept(table)) continue;
                result.add(table);
            }
            String[] stringArray = result.toArray(new String[0]);
            return stringArray;
        }
        finally {
            connection.close();
        }
    }

    public void emptyTables() throws Exception {
        this.executeOnTables(this.tables, new TableSetOperation(){

            @Override
            public void execute(String aTable) throws Exception {
                DatabaseUtils.this.emptyTable(aTable);
            }
        });
    }

    public void emptyTables(ITableFilterSimple aSelection) throws Exception {
        this.executeOnTables(aSelection, new TableSetOperation(){

            @Override
            public void execute(String aTable) throws Exception {
                DatabaseUtils.this.emptyTable(aTable);
            }
        });
    }

    public void emptyTable(String aTable) throws Exception {
        this.executeSql("delete from " + aTable);
    }

    public void dropTables() throws Exception {
        this.dropTables(this.tables);
    }

    public void dropTables(ITableFilterSimple aTables) throws Exception {
        final String[] tableNames = this.getTableNames(aTables);
        String[] sortedTables = this.executeInTransaction(new JdbcUnitOfWork<String[]>(){

            @Override
            public String[] execute(Connection aConnection) throws Exception {
                DatabaseConnection connection = new DatabaseConnection(aConnection);
                DatabaseSequenceFilter filter = new DatabaseSequenceFilter((IDatabaseConnection)connection, tableNames);
                FilteredDataSet dataset = new FilteredDataSet((ITableFilter)filter, connection.createDataSet(tableNames));
                return dataset.getTableNames();
            }
        });
        for (int i = sortedTables.length - 1; i >= 0; --i) {
            this.dropTable(sortedTables[i]);
        }
    }

    public void dropTable(final String aTable) throws Exception {
        this.executeInTransaction(new JdbcUnitOfWork<Void>(){

            @Override
            public Void execute(Connection aConnection) throws Exception {
                DatabaseUtils.this.executeUpdate(aConnection, "drop table " + aTable, new Object[0]);
                return null;
            }
        });
    }

    public int executeSql(String aSql) throws Exception {
        return this.executeSql(aSql, new Object[0]);
    }

    public int executeSql(String aSql, Object aArg) throws Exception {
        return this.executeSql(aSql, new Object[]{aArg});
    }

    public int executeSql(final String aSql, final Object[] aArgs) throws Exception {
        return this.executeInTransaction(new JdbcUnitOfWork<Integer>(){

            @Override
            public Integer execute(Connection aConnection) throws Exception {
                PreparedStatement stmt = aConnection.prepareStatement(aSql);
                DatabaseUtils.this.setPreparedParams(aArgs, stmt);
                return stmt.executeUpdate();
            }
        });
    }

    public ResultSet executeQuery(Connection aConnection, String aSql) {
        return this.executeQuery(aConnection, aSql, new Object[0]);
    }

    public ResultSet executeQuery(Connection aConnection, String aSql, Object aArg) {
        return this.executeQuery(aConnection, aSql, new Object[]{aArg});
    }

    public ResultSet executeQuery(Connection aConnection, String aSql, Object[] aArgs) {
        try {
            PreparedStatement statement = aConnection.prepareStatement(aSql);
            this.setPreparedParams(aArgs, statement);
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int executeUpdate(Connection aConnection, String aSql, Object ... aArgs) {
        try {
            PreparedStatement statement = aConnection.prepareStatement(aSql);
            this.setPreparedParams(aArgs, statement);
            return statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setPreparedParams(Object[] aArgs, PreparedStatement aStatement) throws SQLException {
        for (int i = 1; i <= aArgs.length; ++i) {
            this.setPreparedParam(i, aStatement, aArgs[i - 1]);
        }
    }

    private void setPreparedParam(int aIndex, PreparedStatement aStatement, Object aObject) throws SQLException {
        if (aObject instanceof Integer) {
            aStatement.setInt(aIndex, (Integer)aObject);
        } else if (aObject instanceof Long) {
            aStatement.setLong(aIndex, (Long)aObject);
        } else if (aObject instanceof String) {
            aStatement.setString(aIndex, (String)aObject);
        } else {
            TestCase.fail((String)("Unsupported object type for prepared statement: " + aObject.getClass() + " value: " + aObject + " statement: " + aStatement));
        }
    }

    public int getTableSize(final String aTable) throws Exception {
        return this.executeInTransaction(new JdbcUnitOfWork<Integer>(){

            @Override
            public Integer execute(Connection aConnection) throws Exception {
                ResultSet resultSet = DatabaseUtils.this.executeQuery(aConnection, "select count(*) from " + aTable);
                resultSet.next();
                return resultSet.getInt(1);
            }
        });
    }

    public int countResultSet(ResultSet aResultSet) throws SQLException {
        int count = 0;
        while (aResultSet.next()) {
            ++count;
        }
        return count;
    }

    public static interface TableSetOperation {
        public void execute(String var1) throws Exception;
    }

    public static interface JdbcUnitOfWork<T> {
        public T execute(Connection var1) throws Exception;
    }

    public static interface TableSet {
        public boolean contains(String var1);
    }
}

