/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.wamblee.support.jndi.StubInitialContextFactory;
import org.wamblee.support.persistence.JpaCustomizerBuilder;
import org.wamblee.support.persistence.PersistenceUnitDescription;

public class JpaBuilder {
    private static final Logger LOGGER = Logger.getLogger(JpaBuilder.class.getName());
    private PersistenceUnitDescription persistenceUnit;
    private DataSource dataSource;
    private EntityManagerFactory factory;

    public JpaBuilder(DataSource aDataSource, PersistenceUnitDescription aPersistenceUnit) {
        this.persistenceUnit = aPersistenceUnit;
        this.dataSource = aDataSource;
        StubInitialContextFactory.register();
    }

    public void start() throws Exception {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.persistenceUnit.getJndiName(), (Object)this.dataSource);
        }
        catch (NamingException e) {
            throw new RuntimeException("JNDI problem", e);
        }
        this.factory = this.createFactory();
        try {
            this.execute(new JpaUnitOfWork<Void>(){

                @Override
                public Void execute(EntityManager aEm) {
                    return null;
                }
            });
        }
        catch (PersistenceException e) {
            this.factory.close();
            throw e;
        }
    }

    public void stop() {
        StubInitialContextFactory.unregister();
        this.factory.close();
    }

    public EntityManagerFactory createFactory() {
        TreeMap<String, String> jpaProps = new TreeMap<String, String>();
        JpaCustomizerBuilder.getCustomizer().customize(this.persistenceUnit, jpaProps);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.persistenceUnit.getUnitName(), jpaProps);
        LOGGER.info("Using " + emf.getClass());
        return emf;
    }

    public <T> T execute(JpaUnitOfWork<T> aWork) throws Exception {
        EntityManager em = this.factory.createEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        try {
            T value = aWork.execute(em);
            transaction.commit();
            T t = value;
            return t;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception occured", e);
            transaction.rollback();
            throw e;
        }
        finally {
            em.close();
        }
    }

    public static interface JpaUnitOfWork<T> {
        public T execute(EntityManager var1) throws Exception;
    }
}

