/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import javax.sql.DataSource;
import org.dbunit.IDatabaseTester;
import org.wamblee.support.persistence.Database;
import org.wamblee.support.persistence.DatabaseBuilder;
import org.wamblee.support.persistence.DatabaseUtils;
import org.wamblee.support.persistence.JpaBuilder;
import org.wamblee.support.persistence.JpaCustomizerBuilder;
import org.wamblee.support.persistence.PersistenceUnitDescription;

public class JpaTester {
    private PersistenceUnitDescription persistenceUnit;
    private Database db;
    private DataSource dataSource;
    private DatabaseUtils dbUtils;
    private JpaBuilder jpaBuilder;
    private IDatabaseTester dbTester;

    public JpaTester(PersistenceUnitDescription aPersistenceUnit) {
        this.persistenceUnit = aPersistenceUnit;
    }

    public void start() throws Exception {
        this.db = DatabaseBuilder.getDatabase(new String[0]);
        this.dataSource = this.db.start();
        this.dbUtils = new DatabaseUtils(this.dataSource, this.persistenceUnit.getTables());
        this.dbUtils.start();
        this.dbUtils.dropTables();
        this.dbUtils.dropTables(JpaCustomizerBuilder.getCustomizer().getJpaTables());
        this.jpaBuilder = new JpaBuilder(this.dataSource, this.persistenceUnit);
        this.jpaBuilder.start();
        this.dbTester = this.dbUtils.createDbTester();
    }

    public void stop() {
        if (this.jpaBuilder != null) {
            this.jpaBuilder.stop();
        }
        if (this.dbUtils != null) {
            this.dbUtils.stop();
        }
        if (this.db != null) {
            this.db.stop();
        }
    }

    public Database getDb() {
        return this.db;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public IDatabaseTester getDbTester() {
        return this.dbTester;
    }

    public DatabaseUtils getDbUtils() {
        return this.dbUtils;
    }

    public JpaBuilder getJpaBuilder() {
        return this.jpaBuilder;
    }

    public PersistenceUnitDescription getPersistenceUnit() {
        return this.persistenceUnit;
    }
}

