/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.support.persistence;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import org.wamblee.support.ThreadSpecificProxyFactory;
import org.wamblee.support.persistence.JpaBuilder;

public class TransactionProxyFactory<T> {
    private static final ThreadSpecificProxyFactory<EntityManager> ENTITY_MANAGER = new ThreadSpecificProxyFactory<EntityManager>(EntityManager.class);
    private JpaBuilder jpaBuilder;
    private Class<T> clazz;

    public TransactionProxyFactory(JpaBuilder aJpaBuilder, Class<T> aClass) {
        this.jpaBuilder = aJpaBuilder;
        this.clazz = aClass;
    }

    public EntityManager getTransactionScopedEntityManager() {
        return ENTITY_MANAGER.getProxy();
    }

    public T getProxy(T aService) {
        UnitOfWorkInvocationHandler<T> handler = new UnitOfWorkInvocationHandler<T>(aService);
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }

    private class UnitOfWorkInvocationHandler<T>
    implements InvocationHandler {
        private T service;

        public UnitOfWorkInvocationHandler(T aService) {
            this.service = aService;
        }

        @Override
        public Object invoke(Object aProxy, final Method aMethod, final Object[] aArgs) throws Throwable {
            return TransactionProxyFactory.this.jpaBuilder.execute(new JpaBuilder.JpaUnitOfWork<Object>(){

                @Override
                public Object execute(EntityManager aEm) throws Exception {
                    try {
                        ENTITY_MANAGER.set(aEm);
                        Object object = aMethod.invoke(UnitOfWorkInvocationHandler.this.service, aArgs);
                        return object;
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw new RuntimeException(e);
                    }
                    finally {
                        ENTITY_MANAGER.set(null);
                    }
                }
            });
        }
    }
}

