/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.inject;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.wamblee.inject.Injector;
import org.wamblee.reflection.Accessor;
import org.wamblee.reflection.AnnotationUtils;

/**
 * Injector that performs additional injection on top of the injections that are standard
 * available (e.g. entity manager in Java SE environment).
 * 
 * @author Erik Brakkee
 */
public class JavaEETestInjector implements Injector {

    private EntityManager entityManager;
    private Injector delegate;
    private List<Accessor> accessors;

    /**
     * Constructs the injector. 
     * @param aClass Class to inject for. 
     * @param aEntityManager Entity manager. 
     * @param aDelegate Injecto to delegate to to perform the standard injections. 
     */
    public JavaEETestInjector(Class aClass, EntityManager aEntityManager,
        Injector aDelegate) {
        entityManager = aEntityManager;
        delegate = aDelegate;
        accessors = AnnotationUtils.analyse(aClass, PersistenceContext.class);
    }

    @Override
    public void inject(Object aComponent) {
        delegate.inject(aComponent);
        for (Accessor accessor: accessors) {
            accessor.set(aComponent, entityManager);
        }
    }

}
