/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.jndi;

import java.util.HashMap;
import java.util.Map;

import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

/**
 * Initial context implementation. 
 * 
 * @author Erik Brakkee
 */
class StubInitialContext extends InitialContext {
    private Map<String, Object> bindings = new HashMap<String, Object>();

    public StubInitialContext() throws NamingException {
        super(true);
    }

    @Override
    public void bind(String aName, Object aObj) throws NamingException {
        bindings.put(aName, aObj);
    }
    
    @Override
    public void unbind(String aName) throws NamingException {
        bindings.remove(aName);
    }

    @Override
    public Object lookup(String aName) throws NamingException {
        Object value = bindings.get(aName);
        if (value == null) {
            throw new NameNotFoundException(aName);
        }
        return value;
    }
    
    @Override
    public void bind(Name aName, Object aObj) throws NamingException {
        bind(aName.toString(), aObj);
    }
    
    @Override
    public void unbind(Name aName) throws NamingException {
        unbind(aName.toString());
    }

    @Override
    public Object lookup(Name aName) throws NamingException {
        return lookup(aName.toString());
    }
}
