/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.test.persistence;

/**
 * Description of a specific database.
 */
public class DatabaseDescription {

    private String[] itsCapabilities;
    private String itsDatabase;
    private String itsOther;

    /**
     * Constructs the description.
     * 
     * @param aCapabilities
     *            List of all capabilities.
     * @param aDatabase
     *            Database.
     * @param aOther
     *            Other information.
     */
    public DatabaseDescription(String[] aCapabilities, String aDatabase,
        String aOther) {
        itsCapabilities = aCapabilities;
        itsDatabase = aDatabase;
        itsOther = aOther;
    }

    @Override
    public String toString() {
        return "\n  Database " + itsDatabase + "\n    Capabilities: " +
            printCapabilities() + "\n    Other info:   " + itsOther;
    }

    private String printCapabilities() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < itsCapabilities.length; i++) {
            res.append(itsCapabilities[i]);
            if (i < itsCapabilities.length - 1) {
                res.append(", "); 
            }
        }
        return res.toString();
    }
}
