/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.test.persistence;

import java.util.Map;
import java.util.ServiceLoader;

import org.dbunit.dataset.filter.ITableFilterSimple;

/**
 * JPA customizer is used to customize properties for a given JPA
 * implementation.
 * 
 * Implementations of JpaCustomizer are found using {@link ServiceLoader}. In
 * case of testing with a specific JPA provider, the customizer library for that
 * JPA provider must be on the classpath as well.
 * 
 * @author Erik Brakkee
 */
public interface JpaCustomizer {

    /**
     * Customizes the persistence unit through properties. 
     * @param aPersistenceUnit Persistence unit. 
     * @param aJpaProperties Current properties. 
     */
    void customize(PersistenceUnitDescription aPersistenceUnit,
        Map<String, String> aJpaProperties);

    /**
     * Gets the tables specific to the JPA provider. 
     * @return Tables. 
     */
    ITableFilterSimple getJpaTables();
}
