/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.test.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * JPA customizer builder implements the {@link ServiceLoader} based mechanism for looking up 
 * JPA customizers. 
 */
public class JpaCustomizerBuilder {

    private static final ServiceLoader<JpaCustomizer> CUSTOMIZERS = ServiceLoader
        .load(JpaCustomizer.class);

    /**
     * Gets the customizer to use. This is a composite customizer that combines all customizers that
     * were found. 
     * @return JPA customizer. 
     */
    public static JpaCustomizer getCustomizer() {
        List<JpaCustomizer> customizers = new ArrayList<JpaCustomizer>();
        for (JpaCustomizer customizer : CUSTOMIZERS) {
            customizers.add(customizer);
        }
        return new CompositeJpaCustomizer(customizers);
    }
}
