/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.test.persistence;


/**
 * Describes a persistence unit. 
 * 
 * @author Erik Brakkee
 */
public class PersistenceUnitDescription {

    private String jndiName;
    private String unitName;

    /**
     * Constructs the description. 
     * @param aJndiName Jndi name. 
     * @param aUnitName Persistence unit name. 
     */
    public PersistenceUnitDescription(String aJndiName, String aUnitName) {
        jndiName = aJndiName;
        unitName = aUnitName;
    }

    /**
     * @return JNDI name. 
     */
    public String getJndiName() {
        return jndiName;
    }

    /**
     * Persistence unit name. 
     */
    public String getUnitName() {
        return unitName;
    }
}
