/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.inject;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import junit.framework.TestCase;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.inject.InjectorFactory;
import org.wamblee.inject.InjectorFactoryBuilder;
import org.wamblee.test.inject.JavaEETestInjectorFactory;

public class JavaEETestInjectorFactoryTest {
    @PersistenceContext
    private EntityManager entityManager;
    private EntityManager entityManager2;

    @PersistenceContext
    public EntityManager getEntityManager() {
        return this.entityManager2;
    }

    public void setEntityManager(EntityManager aEm) {
        this.entityManager2 = aEm;
    }

    @Test
    public void testXyz() {
        EntityManager em = (EntityManager)Mockito.mock(EntityManager.class);
        InjectorFactoryBuilder.setInjectorFactory((InjectorFactory)new JavaEETestInjectorFactory(em));
        TestCase.assertNull((Object)this.entityManager);
        TestCase.assertNull((Object)this.entityManager2);
        InjectorFactoryBuilder.getInjector().inject((Object)this);
        TestCase.assertNotNull((Object)em);
        TestCase.assertSame((Object)em, (Object)this.entityManager);
        TestCase.assertSame((Object)em, (Object)this.entityManager2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongType() {
        EntityManager em = (EntityManager)Mockito.mock(EntityManager.class);
        InjectorFactoryBuilder.setInjectorFactory((InjectorFactory)new JavaEETestInjectorFactory(em));
        X x = new X();
        InjectorFactoryBuilder.getInjector().inject((Object)x);
    }

    public static class X {
        @PersistenceContext
        Integer wrongType;
    }
}

