/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.jndi;

import javax.naming.InitialContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.test.jndi.JndiProxyFactory;
import org.wamblee.test.jndi.StubInitialContextFactory;

public class JndiProxyFactoryTest {
    private static final String NAA_NA_NA_NAA_NA = "naa, na, na, naa, na";
    private static final String JNDI = "jndi/xyz";
    private MyInterface intf;
    private InitialContext ctx;
    private MyInterface proxy;

    @Before
    public void setUp() throws Exception {
        StubInitialContextFactory.register();
        this.intf = (MyInterface)Mockito.mock(MyInterface.class);
        this.ctx = new InitialContext();
        JndiProxyFactory factory = new JndiProxyFactory(MyInterface.class, JNDI);
        this.proxy = (MyInterface)factory.getProxy();
    }

    @After
    public void tearDown() throws Exception {
        StubInitialContextFactory.unregister();
    }

    @Test
    public void testFoundAtJndi() throws Exception {
        this.ctx.bind(JNDI, (Object)this.intf);
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        Assert.assertEquals((long)1L, (long)this.proxy.execute());
    }

    @Test(expected=JndiProxyFactory.JndiWiringException.class)
    public void testNotFoundAtJndi() {
        this.proxy.execute();
    }

    @Test(expected=JndiProxyFactory.JndiWiringException.class)
    public void testWrongTypeAtJndi() throws Exception {
        this.ctx.bind(JNDI, (Object)"a string type");
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        Assert.assertEquals((long)1L, (long)this.proxy.execute());
    }

    @Test(expected=JndiProxyFactory.JndiWiringException.class)
    public void testNullAtJndi() throws Exception {
        this.ctx.bind(JNDI, null);
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        Assert.assertEquals((long)1L, (long)this.proxy.execute());
    }

    @Test
    public void testFoundButInvocationThrowsException() throws Exception {
        this.ctx.bind(JNDI, (Object)this.intf);
        Mockito.when((Object)this.intf.execute()).thenThrow(new Throwable[]{new RuntimeException(NAA_NA_NA_NAA_NA)});
        try {
            this.proxy.execute();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)NAA_NA_NA_NAA_NA, (Object)e.getMessage());
        }
    }

    private static interface MyInterface {
        public int execute();
    }
}

