/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import java.sql.Connection;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.junit.Test;
import org.wamblee.test.persistence.Database;
import org.wamblee.test.persistence.DatabaseBuilder;
import org.wamblee.test.persistence.ExternalDatabase;

public class ExternalDatabaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalDB() throws Exception {
        Database inmemory = DatabaseBuilder.getDatabase((String[])new String[]{"INMEMORY"});
        try {
            inmemory.start();
            System.setProperty("TEST_DB_URL", inmemory.getExternalJdbcUrl());
            System.setProperty("TEST_DB_USER", inmemory.getUsername());
            System.setProperty("TEST_DB_PASSWORD", inmemory.getPassword());
            Database external = DatabaseBuilder.getDatabase((String[])new String[]{"EXTERNAL"});
            TestCase.assertTrue((boolean)(external instanceof ExternalDatabase));
            try {
                DataSource ds = external.start();
                Connection conn = ds.getConnection();
                try {
                    System.out.println("Database name: " + conn.getMetaData().getDatabaseProductName());
                }
                finally {
                    conn.close();
                }
            }
            finally {
                external.stop();
            }
        }
        finally {
            inmemory.stop();
        }
    }
}

