/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.transactions;

import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.test.transactions.SimpleUserTransaction;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.UserTransactionCallback;

public class SimpleUserTransactionTest {
    private UserTransactionCallback callback;
    private TransactionResource resource1;
    private TransactionResource resource2;
    private Object tx1;
    private Object tx2;
    private SimpleUserTransaction tx;

    @Before
    public void setUp() {
        this.callback = (UserTransactionCallback)Mockito.mock(UserTransactionCallback.class);
        this.resource1 = (TransactionResource)Mockito.mock(TransactionResource.class);
        this.resource2 = (TransactionResource)Mockito.mock(TransactionResource.class);
        this.tx1 = Mockito.mock(Object.class);
        this.tx2 = Mockito.mock(Object.class);
        Mockito.when((Object)this.resource1.begin()).thenReturn(this.tx1);
        Mockito.when((Object)this.resource2.begin()).thenReturn(this.tx2);
    }

    @Test
    public void testTransactionBegin() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1});
        Assert.assertEquals((int)6, (int)this.tx.getStatus());
        this.tx.begin();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1});
        Mockito.reset((Object[])new TransactionResource[]{this.resource1});
        Assert.assertEquals((int)0, (int)this.tx.getStatus());
    }

    @Test
    public void testTransactionCommit() throws Exception {
        this.testTransactionBegin();
        this.tx.commit();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).commit(Mockito.same((Object)this.tx1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1});
        ((UserTransactionCallback)Mockito.verify((Object)this.callback)).transactionFinished();
        Assert.assertEquals((int)6, (int)this.tx.getStatus());
    }

    @Test
    public void testTransactionRollback() throws Exception {
        this.testTransactionBegin();
        this.tx.rollback();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).rollback(Mockito.same((Object)this.tx1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1});
        Assert.assertEquals((int)6, (int)this.tx.getStatus());
        ((UserTransactionCallback)Mockito.verify((Object)this.callback)).transactionFinished();
    }

    @Test
    public void testTransactionStatusSetrollbackOnly() throws Exception {
        this.testTransactionBegin();
        this.tx.setRollbackOnly();
        Assert.assertEquals((int)1, (int)this.tx.getStatus());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.callback});
    }

    @Test
    public void testTransactionRollbackWhenSetRollbackOnly() throws Exception {
        this.testTransactionStatusSetrollbackOnly();
        this.tx.rollback();
        Assert.assertEquals((int)6, (int)this.tx.getStatus());
        ((TransactionResource)Mockito.verify((Object)this.resource1)).rollback(Mockito.same((Object)this.tx1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1});
    }

    @Test
    public void testTransactionCommitWhenSetRollbackOnly() throws Exception {
        this.testTransactionStatusSetrollbackOnly();
        try {
            this.tx.commit();
            Assert.fail();
        }
        catch (RollbackException e) {
            Assert.assertEquals((int)6, (int)this.tx.getStatus());
        }
    }

    @Test
    public void testMultipleResources() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1, this.resource2});
        this.tx.begin();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).begin();
        ((TransactionResource)Mockito.verify((Object)this.resource2)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1, this.resource2});
        Mockito.reset((Object[])new TransactionResource[]{this.resource1, this.resource2});
        Assert.assertEquals((int)0, (int)this.tx.getStatus());
        this.tx.commit();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).commit(Mockito.same((Object)this.tx1));
        ((TransactionResource)Mockito.verify((Object)this.resource2)).commit(Mockito.same((Object)this.tx2));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1, this.resource2});
        ((UserTransactionCallback)Mockito.verify((Object)this.callback)).transactionFinished();
    }

    @Test
    public void testSetTransactionTimeoutIgnored() throws Exception {
        this.testTransactionBegin();
        this.tx.setTransactionTimeout(1000);
    }

    @Test(expected=NotSupportedException.class)
    public void testNestedTransaction() throws Exception {
        this.testTransactionBegin();
        this.tx.begin();
    }

    @Test(expected=IllegalStateException.class)
    public void testCommitWhileNotInATransaction() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1});
        this.tx.commit();
    }

    @Test
    public void testCommitFailsOnSomeResources() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1, this.resource2});
        this.tx.begin();
        ((TransactionResource)Mockito.doThrow((Throwable)new RuntimeException("failed")).when((Object)this.resource1)).commit(Mockito.any());
        try {
            this.tx.commit();
            Assert.fail();
        }
        catch (HeuristicMixedException e) {
            ((TransactionResource)Mockito.verify((Object)this.resource2)).rollback(Mockito.same((Object)this.tx2));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRollbackWhileNotInATransaction() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1});
        this.tx.rollback();
    }

    @Test(expected=IllegalStateException.class)
    public void testSetrollbackonlyWhileNotInATransaction() throws Exception {
        this.tx = new SimpleUserTransaction(this.callback, new TransactionResource[]{this.resource1});
        this.tx.setRollbackOnly();
    }
}

