/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.transactions;

import javax.persistence.EntityManager;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.test.persistence.JpaBuilder;
import org.wamblee.test.persistence.JpaTester;
import org.wamblee.test.persistence.MyPersistenceUnit;
import org.wamblee.test.persistence.PersistenceUnitDescription;
import org.wamblee.test.transactions.TransactionProxyFactory;

public class TransactionProxyFactoryTestBase {
    private JpaTester jpaTester;

    @Before
    public void setUp() throws Exception {
        this.jpaTester = new JpaTester((PersistenceUnitDescription)new MyPersistenceUnit());
        this.jpaTester.start();
    }

    @After
    public void tearDown() throws Exception {
        this.jpaTester.stop();
    }

    @Test
    public void testServiceIsInvoked() throws Exception {
        TransactionProxyFactory factory = new TransactionProxyFactory(this.jpaTester.getJpaBuilder(), Service.class);
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.execute(10)).thenReturn((Object)200);
        Service proxy = (Service)factory.getProxy((Object)service);
        int res = proxy.execute(10);
        Assert.assertEquals((int)200, (int)res);
        ((Service)Mockito.verify((Object)service)).execute(10);
    }

    @Test
    public void testServiceThrowsException() throws Exception {
        TransactionProxyFactory factory = new TransactionProxyFactory(this.jpaTester.getJpaBuilder(), Service.class);
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.execute(10)).thenThrow(new Throwable[]{new RuntimeException("xyz")});
        Service proxy = (Service)factory.getProxy((Object)service);
        try {
            int res = proxy.execute(10);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"xyz", (String)e.getMessage());
        }
    }

    @Test
    public void testEntityManagerIsPassed() throws Exception {
        final TransactionProxyFactory factory = new TransactionProxyFactory(this.jpaTester.getJpaBuilder(), Service.class);
        Service service = new Service(){
            private EntityManager em;
            {
                this.em = factory.getTransactionScopedEntityManager();
            }

            @Override
            public int execute(int aValue) throws Exception {
                Assert.assertNotNull((Object)this.em);
                Assert.assertTrue((boolean)this.em.isOpen());
                return 0;
            }
        };
        final Service proxy = (Service)factory.getProxy((Object)service);
        this.jpaTester.getJpaBuilder().execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) throws Exception {
                assert (aEm != null);
                proxy.execute(10);
                return null;
            }
        });
    }

    public static interface Service {
        public int execute(int var1) throws Exception;
    }
}

