/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.jndi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JndiProxyFactory<T> {
    private String jndi;
    private Class clazz;

    public JndiProxyFactory(Class<T> aClass, String aJndi) {
        if (!aClass.isInterface()) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not an interface");
        }
        this.clazz = aClass;
        this.jndi = aJndi;
    }

    public T getProxy() {
        JndiInvocationHandler handler = new JndiInvocationHandler();
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }

    private class JndiInvocationHandler
    implements InvocationHandler {
        private JndiInvocationHandler() {
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            Object svcObj = null;
            try {
                InitialContext ctx = new InitialContext();
                svcObj = ctx.lookup(JndiProxyFactory.this.jndi);
            }
            catch (NamingException e) {
                throw new JndiWiringException("Error looking up object in JNDI at '" + JndiProxyFactory.this.jndi + "'", e);
            }
            if (svcObj == null) {
                throw new JndiWiringException("Object at '" + JndiProxyFactory.this.jndi + "' is null");
            }
            if (!JndiProxyFactory.this.clazz.isInstance(svcObj)) {
                throw new JndiWiringException("Object in JNDI tree at '" + JndiProxyFactory.this.jndi + "' not of type " + JndiProxyFactory.this.clazz.getName() + " but of type " + svcObj.getClass().getName());
            }
            Object svc = svcObj;
            try {
                return aMethod.invoke(svc, aArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public static class JndiWiringException
    extends RuntimeException {
        public JndiWiringException(String aMsg, Throwable aCause) {
            super(aMsg, aCause);
        }

        public JndiWiringException(String aMsg) {
            super(aMsg);
        }
    }
}

