/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import org.wamblee.test.persistence.Database;
import org.wamblee.test.persistence.DerbyDatabase;

public class DatabaseStarter {
    private Class databaseClass;

    public static void main(String[] aArgs) throws Exception {
        String clazz = aArgs[0];
        try {
            new DatabaseStarter(Class.forName(clazz)).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\nUsage: ant dbClass ");
        }
    }

    public DatabaseStarter(Class aClass) throws Exception {
        if (!Database.class.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("Class '" + aClass.getName() + "' is not a subclass of Database");
        }
        this.databaseClass = aClass;
    }

    public DatabaseStarter() throws Exception {
        this(DerbyDatabase.class);
    }

    public void start() throws Exception {
        Database lDatabase = (Database)this.databaseClass.newInstance();
        lDatabase.start();
        System.out.println("Database has been started. ");
        System.out.println();
        System.out.println("=======================================================");
        System.out.println("Connection details:");
        System.out.println("  JDBC URL:     " + lDatabase.getExternalJdbcUrl());
        System.out.println("  username:     '" + lDatabase.getUsername() + "'");
        System.out.println("  password:     '" + lDatabase.getPassword() + "'");
        System.out.println("Interrupt the program to stop the database.");
        System.out.println("=======================================================");
        System.out.println("You must now populate the database with a schema. Use 'ant help' for information.");
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

