/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.transactions;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.UserTransactionCallback;

public class SimpleUserTransaction
implements UserTransaction {
    private UserTransactionCallback callback;
    private TransactionResource[] resources;
    private Object[] txStates;
    private int status;

    public SimpleUserTransaction(UserTransactionCallback aCallback, TransactionResource<?> ... aResources) {
        this.callback = aCallback;
        this.resources = aResources;
        this.txStates = new Object[this.resources.length];
        this.status = 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.status == 0) {
            throw new NotSupportedException("Nested transactions not supported!");
        }
        for (int i = 0; i < this.resources.length; ++i) {
            this.txStates[i] = this.resources[i].begin();
        }
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("Rollback while not in a transaction");
        }
        try {
            for (int i = 0; i < this.resources.length; ++i) {
                this.resources[i].rollback(this.txStates[i]);
            }
        }
        finally {
            this.status = 6;
            this.callback.transactionFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 1) {
            this.rollback();
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException("Commit while not in a transaction");
        }
        try {
            boolean committing = true;
            for (int i = 0; i < this.resources.length; ++i) {
                try {
                    if (committing) {
                        this.resources[i].commit(this.txStates[i]);
                        continue;
                    }
                    this.resources[i].rollback(this.txStates[i]);
                    continue;
                }
                catch (Exception e) {
                    committing = false;
                }
            }
            if (!committing) {
                throw new HeuristicMixedException("Commit failed");
            }
        }
        finally {
            this.status = 6;
            this.callback.transactionFinished();
        }
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("setRollbackOnly() while not in a transaction");
        }
        this.status = 1;
    }

    public void setTransactionTimeout(int aSeconds) throws SystemException {
    }
}

