/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.cdi;

import javax.enterprise.inject.spi.BeanManager;

import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

/**
 * Simple wrapper class for creating a bean manager in a Java SE environment 
 * This class wraps an existing implementation of CDI. 
 * 
 * @author Erik Brakkee
 */
public class BeanManagerSetup {

    private Weld weld;
    private WeldContainer container;
    private BeanManager beanManager;

    /**
     * Constructs the setup class.
     */
    public BeanManagerSetup() {
        // Empty
    }

    /**
     * Must be called to initialize the bean manager. 
     */
    public void initialize() {
        weld = new Weld();
        container = weld.initialize();
        beanManager = container.getBeanManager();
    }

    /**
     * Gets the bean manager. Should only be called after {@link #initialize()}
     * @return Bean manager. 
     */
    public BeanManager getBeanManager() {
        return beanManager;
    }

    /**
     * Cleans up the bean manager. 
     */
    public void shutdown() {
        weld.shutdown();
        weld = null;
        container = null;
        beanManager = null;
    }
}
