/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.persistence;

import java.util.List;
import java.util.Map;

import org.dbunit.dataset.filter.ITableFilterSimple;

/**
 * Composite JPA customizer that applies the customizations from several JPA
 * customizers.
 * 
 * @author Erik Brakkee
 */
public class CompositeJpaCustomizer implements JpaCustomizer {

    private List<JpaCustomizer> customizers;
    private CompositeJpaTables tables;

    /**
     * Construcst the customizer.
     * 
     * @param aCustomizers
     *            List of customizers.
     */
    public CompositeJpaCustomizer(List<JpaCustomizer> aCustomizers) {
        customizers = aCustomizers;
        tables = new CompositeJpaTables();
        for (JpaCustomizer customizer : customizers) {
            tables.add(customizer.getJpaTables());
        }
    }

    @Override
    /**
     * Applies all customizations in an undefined order. 
     */
    public void customize(PersistenceUnitDescription aPersistenceUnit,
        Map<String, String> aJpaProperties) {
        for (JpaCustomizer customizer : customizers) {
            customizer.customize(aPersistenceUnit, aJpaProperties);
        }
    }

    @Override
    public ITableFilterSimple getJpaTables() {
        return tables;
    }

}
