/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.persistence;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.wamblee.test.transactions.TransactionResult;

/**
 * Logging the result of a transaction.
 * 
 * @author Erik Brakkee
 * 
 */
public class LoggingTransactionResultCallback implements
    TransactionResultCallback {

    private static final Logger LOGGER = Logger
        .getLogger(LoggingTransactionResultCallback.class.getName());

    private Level level;

    public LoggingTransactionResultCallback(Level aLevel) {
        level = aLevel;
    }

    @Override
    public void status(TransactionResult aResult) {
        LOGGER.log(level, "Transaction result " + aResult);
    }
}
