/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.persistence;

import org.wamblee.test.transactions.TransactionResult;

import static junit.framework.Assert.*;

/**
 * Specific transaction result callback to require a specific transaction
 * result.
 * 
 * @author Erik Brakkee
 * 
 */
public class RequireTransactionStatus implements TransactionResultCallback {

    private TransactionResult result;

    /**
     * Constructs the callback.
     * 
     * @param aResult
     *            Required result.
     */
    public RequireTransactionStatus(TransactionResult aResult) {
        result = aResult;
    }

    @Override
    public void status(TransactionResult aResult) {
        if (!result.equals(aResult)) {
            fail("Required transaction result was " + result +
                " but actual result was " + aResult);
        }
    }

}
