/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.transactions;

import java.util.List;

import javax.transaction.UserTransaction;

/**
 * Transaction factory implementation that creates {@link SimpleUserTransaction}
 * objects.
 * 
 * @author Erik Brakkee
 * 
 */
public class DefaultUserTransactionFactory implements UserTransactionFactory {

    /**
     * Constructs the factory.
     */
    public DefaultUserTransactionFactory() {
        // Empty.
    }

    @Override
    public UserTransaction create(UserTransactionCallback aCallback,
        List<TransactionResource> aResources) {
        return new SimpleUserTransaction(aCallback, aResources
            .toArray(new TransactionResource[0]));
    }

}
