/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.test.transactions;

/**
 * Transaction result.
 * 
 * @author Erik Brakkee
 */
public enum TransactionResult {
    /**
     * Nothing was done. The transaction was committed or rolled back by the
     * application. Most likely an exception occurred and the transaction was
     * rolled back.
     */
    UNKNOWN,

    /**
     * Transaction was committed.
     */
    COMMIT,

    /**
     * Tranasction was rolled back.
     */
    ROLLBACK
}