/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>
 * This package provides basic support utilities for testing with transactions.
 * Depending on the test setup different methods can be used on top of the basic
 * support for transactions with {@link org.wamblee.test.persistence.JpaBuilder}. 
 * These are: 
 * </p>
 * <ul> 
 *   <li> {@link TransactionProxyFactory}: In case you want to test a service and want
 *        "requires new" transaction semantics for your service. </li>
 *   <li> {@link SimpleTransactionManager}: In case you want to manage one or more 
 *        transactional resources through a standard {@link UserTransaction}. </li>  
 * </ul>
 */
package org.wamblee.test.transactions;