/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.inject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.wamblee.inject.InjectorBuilder;
import org.wamblee.inject.InjectorFactory;
import org.wamblee.reflection.ObjectTraversal;
import org.wamblee.test.inject.Binding;
import org.wamblee.test.inject.JavaEETestInjectorFactory;

public class JavaEETestInjectorFactoryTest {
    @Before
    public void setUp() {
        ObjectTraversal.LOGGER.setLevel(Level.FINEST);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINEST);
        ObjectTraversal.LOGGER.addHandler(handler);
    }

    @Test
    public void testXyz() {
        EntityManager em = (EntityManager)Mockito.mock(EntityManager.class);
        InjectorBuilder.setInjectorFactory((InjectorFactory)new JavaEETestInjectorFactory().addEntityManagerBinding(em));
        X x = new X();
        Assert.assertNull((Object)x.entityManager);
        Assert.assertNull((Object)x.entityManager2);
        InjectorBuilder.getInjector().inject((Object)x);
        Assert.assertNotNull((Object)em);
        Assert.assertSame((Object)em, (Object)x.entityManager);
        Assert.assertSame((Object)em, (Object)x.entityManager2);
    }

    @Test
    public void testWrongType() {
        EntityManager em = (EntityManager)Mockito.mock(EntityManager.class);
        InjectorBuilder.setInjectorFactory((InjectorFactory)new JavaEETestInjectorFactory().addEntityManagerBinding(em));
        Y y = new Y();
        InjectorBuilder.getInjector().inject((Object)y);
        Assert.assertNull((Object)y.wrongType);
    }

    @Test
    public void testCustomInjection() {
        JavaEETestInjectorFactory factory = new JavaEETestInjectorFactory();
        factory.addBinding(new Binding(Integer.TYPE, MyAnnotation.class, (Object)100));
        InjectorBuilder.setInjectorFactory((InjectorFactory)factory);
        Z z = new Z();
        z.z = new Z();
        Assert.assertEquals((int)0, (int)z.x);
        InjectorBuilder.getInjector().inject((Object)z);
        Assert.assertEquals((int)100, (int)z.x);
        Assert.assertEquals((int)100, (int)z.z.x);
    }

    public static class Z {
        @MyAnnotation
        private int x;
        @Mock
        private Z z;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface MyAnnotation {
    }

    public static class Y {
        @PersistenceContext
        private Integer wrongType;
    }

    public static final class X {
        @PersistenceContext
        private EntityManager entityManager;
        private EntityManager entityManager2;

        @PersistenceContext
        public EntityManager getEntityManager() {
            return this.entityManager2;
        }

        public void setEntityManager(EntityManager aEm) {
            this.entityManager2 = aEm;
        }
    }
}

