/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.dbunit.IDatabaseTester;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.wamblee.test.persistence.Database;
import org.wamblee.test.persistence.DatabaseBuilder;
import org.wamblee.test.persistence.DatabaseUtils;
import org.wamblee.test.persistence.JpaBuilder;
import org.wamblee.test.persistence.JpaCustomizerBuilder;
import org.wamblee.test.persistence.MyEntity;
import org.wamblee.test.persistence.MyPersistenceUnit;
import org.wamblee.test.persistence.MyTables;
import org.wamblee.test.persistence.PersistenceUnitDescription;

public class DatabaseUtilsTestBase {
    private Database db;
    private DataSource dataSource;
    private PersistenceUnitDescription persistenceUnit;
    private JpaBuilder builder;
    private DatabaseUtils dbutils;
    private IDatabaseTester dbtester;

    @Before
    public void setUp() throws Exception {
        this.db = DatabaseBuilder.getDatabase((String[])new String[0]);
        this.dataSource = this.db.start();
        this.persistenceUnit = new MyPersistenceUnit();
        this.dbutils = new DatabaseUtils(this.dataSource);
        this.dbutils.dropTables((ITableFilterSimple)new MyTables());
        this.dbutils.dropTables(JpaCustomizerBuilder.getCustomizer().getJpaTables());
        this.builder = new JpaBuilder(this.db.getJdbcUrl(), this.db.getUsername(), this.db.getPassword(), this.persistenceUnit);
        this.builder.start();
        Assert.assertEquals((int)0, (int)this.db.getActiveConnections());
        this.dbtester = this.dbutils.createDbTester((ITableFilterSimple)new MyTables());
    }

    @After
    public void tearDown() throws Exception {
        this.dbtester.getConnection().close();
        this.builder.stop();
        this.dbutils.stop();
        Assert.assertEquals((int)0, (int)this.db.getActiveConnections());
        this.db.stop();
    }

    @Test
    public void testTablesCorrect() throws Exception {
        String[] tables = this.dbutils.getTableNames((ITableFilterSimple)new MyTables());
        Assert.assertEquals((int)1, (int)tables.length);
        Assert.assertEquals((String)"XYZ_MYENTITY", (String)tables[0]);
    }

    @Test
    public void testDeleteTables() throws Exception {
        String[] tables = this.dbutils.getTableNames((ITableFilterSimple)new MyTables());
        Assert.assertEquals((int)1, (int)tables.length);
        Assert.assertEquals((String)"XYZ_MYENTITY", (String)tables[0]);
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                return null;
            }
        });
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        this.dbutils.cleanDatabase((ITableFilterSimple)new MyTables());
        table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)0, (int)table.getRowCount());
        this.dbutils.dropTables((ITableFilterSimple)new MyTables());
        this.dbutils.dropTables(JpaCustomizerBuilder.getCustomizer().getJpaTables());
        tables = this.dbutils.getTableNames((ITableFilterSimple)new MyTables());
        Assert.assertEquals((int)0, (int)tables.length);
    }
}

