/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.dbunit.IDatabaseTester;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.test.persistence.DatabaseUtils;
import org.wamblee.test.persistence.JpaBuilder;
import org.wamblee.test.persistence.JpaTester;
import org.wamblee.test.persistence.MyEntity;
import org.wamblee.test.persistence.MyPersistenceUnit;
import org.wamblee.test.persistence.MyTables;
import org.wamblee.test.persistence.PersistenceUnitDescription;
import org.wamblee.test.persistence.TransactionResultCallback;
import org.wamblee.test.transactions.DefaultUserTransactionFactory;
import org.wamblee.test.transactions.SimpleTransactionManager;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.TransactionResult;
import org.wamblee.test.transactions.UserTransactionFactory;

public class MyEntityExampleTestBase {
    private JpaTester jpaTester;
    private JpaBuilder builder;
    private IDatabaseTester dbtester;
    private DatabaseUtils dbutils;

    @Before
    public void setUp() throws Exception {
        this.jpaTester = new JpaTester((PersistenceUnitDescription)new MyPersistenceUnit());
        this.jpaTester.start();
        this.builder = this.jpaTester.getJpaBuilder();
        this.dbtester = this.jpaTester.getDbUtils().createDbTester((ITableFilterSimple)new MyTables());
        this.dbutils = this.jpaTester.getDbUtils();
    }

    @After
    public void tearDown() {
        this.dbutils.stop();
        this.jpaTester.stop();
    }

    @Test
    public void testEntityPersistence() throws Exception {
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                return null;
            }
        });
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        Assert.assertEquals((Object)"a", (Object)table.getValue(0, "SLEUTELTJE"));
        Assert.assertEquals((Object)"b", (Object)table.getValue(0, "VALUE"));
        Assert.assertEquals((int)1, (int)this.dbutils.getTableSize("XYZ_MYENTITY"));
    }

    @Test
    public void testEntityPersistenceWithBasicApi() throws Exception {
        EntityManager em = this.builder.begin();
        MyEntity entity = new MyEntity("a", "b");
        em.persist((Object)entity);
        this.builder.commit(em);
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        Assert.assertEquals((Object)"a", (Object)table.getValue(0, "SLEUTELTJE"));
        Assert.assertEquals((Object)"b", (Object)table.getValue(0, "VALUE"));
        Assert.assertEquals((int)1, (int)this.dbutils.getTableSize("XYZ_MYENTITY"));
    }

    @Test
    public void testEntityPersistenceWithContextualEntityManager() throws Exception {
        this.builder.begin();
        EntityManager em = this.builder.getContextualEntityManager();
        MyEntity entity = new MyEntity("a", "b");
        em.persist((Object)entity);
        this.builder.commit(em);
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        Assert.assertEquals((Object)"a", (Object)table.getValue(0, "SLEUTELTJE"));
        Assert.assertEquals((Object)"b", (Object)table.getValue(0, "VALUE"));
        Assert.assertEquals((int)1, (int)this.dbutils.getTableSize("XYZ_MYENTITY"));
    }

    @Test
    public void testEntityPersistenceWithUserTransactions() throws Exception {
        SimpleTransactionManager manager = new SimpleTransactionManager((UserTransactionFactory)new DefaultUserTransactionFactory());
        manager.addResource((TransactionResource)this.jpaTester.getJpaBuilder());
        UserTransaction transaction = manager.getTransaction();
        transaction.begin();
        EntityManager em = this.builder.getContextualEntityManager();
        MyEntity entity = new MyEntity("a", "b");
        em.persist((Object)entity);
        transaction.commit();
        ITable table = this.dbtester.getDataSet().getTable("XYZ_MYENTITY");
        Assert.assertEquals((int)1, (int)table.getRowCount());
        Assert.assertEquals((Object)"a", (Object)table.getValue(0, "SLEUTELTJE"));
        Assert.assertEquals((Object)"b", (Object)table.getValue(0, "VALUE"));
        Assert.assertEquals((int)1, (int)this.dbutils.getTableSize("XYZ_MYENTITY"));
    }

    @Test
    public void testTransactionCommittedCallback() throws Exception {
        TransactionResultCallback callback = (TransactionResultCallback)Mockito.mock(TransactionResultCallback.class);
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                return null;
            }
        }, callback);
        ((TransactionResultCallback)Mockito.verify((Object)callback)).status(TransactionResult.COMMIT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void testTransactionMarkedForRollback() throws Exception {
        TransactionResultCallback callback = (TransactionResultCallback)Mockito.mock(TransactionResultCallback.class);
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                aEm.getTransaction().setRollbackOnly();
                return null;
            }
        }, callback);
        ((TransactionResultCallback)Mockito.verify((Object)callback)).status(TransactionResult.ROLLBACK);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void testTransactionRolledBack() throws Exception {
        TransactionResultCallback callback = (TransactionResultCallback)Mockito.mock(TransactionResultCallback.class);
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                aEm.getTransaction().rollback();
                return null;
            }
        }, callback);
        ((TransactionResultCallback)Mockito.verify((Object)callback)).status(TransactionResult.UNKNOWN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test
    public void testTransactionCommitted() throws Exception {
        TransactionResultCallback callback = (TransactionResultCallback)Mockito.mock(TransactionResultCallback.class);
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                aEm.getTransaction().commit();
                return null;
            }
        }, callback);
        ((TransactionResultCallback)Mockito.verify((Object)callback)).status(TransactionResult.UNKNOWN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @Test(expected=AssertionFailedError.class)
    public void testTransactionNotCommittedUnexpectedly() throws Exception {
        this.builder.execute((JpaBuilder.JpaUnitOfWork)new JpaBuilder.JpaUnitOfWork<Void>(){

            public Void execute(EntityManager aEm) {
                MyEntity entity = new MyEntity("a", "b");
                aEm.persist((Object)entity);
                aEm.getTransaction().rollback();
                return null;
            }
        });
    }
}

