/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.transactions;

import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.test.transactions.DefaultUserTransactionFactory;
import org.wamblee.test.transactions.SimpleTransactionManager;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.UserTransactionFactory;

public class SimpleTransactionManagerIntegrationTest {
    private TransactionResource resource1;
    private TransactionResource resource2;
    private Object tx1;
    private Object tx2;
    private SimpleTransactionManager manager;

    @Before
    public void setUp() {
        DefaultUserTransactionFactory factory = new DefaultUserTransactionFactory();
        this.manager = new SimpleTransactionManager((UserTransactionFactory)factory);
        this.resource1 = (TransactionResource)Mockito.mock(TransactionResource.class);
        this.resource2 = (TransactionResource)Mockito.mock(TransactionResource.class);
        this.tx1 = Mockito.mock(Object.class);
        this.tx2 = Mockito.mock(Object.class);
        Mockito.when((Object)this.resource1.begin()).thenReturn(this.tx1);
        Mockito.when((Object)this.resource2.begin()).thenReturn(this.tx2);
    }

    @Test
    public void testMultipleResources() throws Exception {
        this.manager.addResource(this.resource1);
        this.manager.addResource(this.resource2);
        UserTransaction tx = this.manager.getTransaction();
        tx.begin();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).begin();
        ((TransactionResource)Mockito.verify((Object)this.resource2)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1, this.resource2});
        Mockito.reset((Object[])new TransactionResource[]{this.resource1, this.resource2});
        Assert.assertEquals((int)0, (int)tx.getStatus());
        tx.commit();
        ((TransactionResource)Mockito.verify((Object)this.resource1)).commit(Mockito.same((Object)this.tx1));
        ((TransactionResource)Mockito.verify((Object)this.resource2)).commit(Mockito.same((Object)this.tx2));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.resource1, this.resource2});
    }

    @Test
    public void testTwoTransactions() throws Exception {
        UserTransaction transaction = this.manager.getTransaction();
        transaction.begin();
        transaction.commit();
        transaction.begin();
        transaction.commit();
    }
}

